USES Crt,Graph;

CONST
 Font=DefaultFont;
 pixColor=lightGray;
 shitColor=Brown;
 enemyColor=Green;
 lineColor=DarkGray;
 shitRad=2;  {ࠤ 窠  }
 enemyRad=2; {ࠤ 宥 }
 minX=0;     { ࠭  }
 minY=0;
 maxX=500;
 maxY=465;

TYPE
 pixObject=record
            x,y,color:integer;
           end;
 direction=record
            x,y:shortint;
            ver:real;
           end;
VAR
 pixels:array[1..1000] of pixObject;
 directions:array[1..8] of direction;
 beginX,beginY,shitX,shitY,enemyX,enemyY,pixNumber,sens:integer;
 hungry,fear:real;

PROCEDURE GrInit;
 var
  grDr,grMode:integer;
 begin
  DetectGraph(grDr,grMode);
  InitGraph(grDr,grMode,'');
 end;

PROCEDURE Borders;
 begin
  SetColor(LineColor);
  Rectangle(minX,minY,maxX,maxY);
 end;

PROCEDURE InitDirections;
 var i:byte;
 begin
  for i:=1 to 3 do
   directions[i].x:=1;
  for i:=5 to 7 do
   directions[i].x:=-1;
  for i:=3 to 5 do
   directions[i].y:=1;
  for i:=7 to 8 do
   directions[i].y:=-1;
  directions[1].y:=-1;
  directions[2].y:=0;
  directions[6].y:=0;
  directions[4].x:=0;
  directions[8].x:=0;
 end;

FUNCTION XYtoNum(i,j:shortint):byte;
 var n:byte;
 begin
  for n:=1 to 8 do
   with directions[n] do
    if (x=i) and (y=j) then begin
     XYtoNum:=n;
     Exit;
    end;
  XYtoNum:=random(8)+1;
 end;

FUNCTION DistanceShit(i,j:real):real;
 begin
  DistanceShit:=SQRT((shitX-i)*(shitX-i)+(shitY-j)*(shitY-j));
 end;

FUNCTION DistanceEnemy(i,j:real):real;
 begin
  DistanceEnemy:=SQRT((enemyX-i)*(enemyX-i)+(enemyY-j)*(enemyY-j));
 end;

FUNCTION PixDirect:byte;
 var r,p:real;
 begin
  r:=Random;
  if r<=directions[1].ver then PixDirect:=1
  else begin
   r:=r-directions[1].ver;
   if r<=directions[2].ver then PixDirect:=2
   else begin
    r:=r-directions[2].ver;
    if r<=directions[3].ver then PixDirect:=3
    else begin
     r:=r-directions[3].ver;
     if r<=directions[4].ver then PixDirect:=4
     else begin
      r:=r-directions[4].ver;
      if r<=directions[5].ver then PixDirect:=5
      else begin
       r:=r-directions[5].ver;
       if r<=directions[6].ver then PixDirect:=6
       else begin
        r:=r-directions[6].ver;
        if r<=directions[7].ver then PixDirect:=7
        else PixDirect:=8;
       end;
      end;
     end;
    end;
   end;
  end;
 end;

FUNCTION Sign(n:real):shortint;
 begin
  if n<0 then Sign:=-1;
  if n=0 then Sign:=0;
  if n>0 then Sign:=1;
 end;

FUNCTION Direct:shortint;
 begin
  case Random(3) of
   0: Direct:=-1;
   1: Direct:=1;
   2: Direct:=0;
  end;
 end;

PROCEDURE Proba4;
 var i:integer;
 begin
  Borders;
  PutPixel(GetMaxX div 2,GetMaxY div 2,pixColor);
  for i:=1 to pixNumber do
   with pixels[i] do begin
    x:=GetMaxX div 2; y:=GetMaxY div 2;
   end;
  repeat
   for i:=1 to pixNumber do
    with pixels[i] do begin
     PutPixel(x,y,0);
     if Random(2)=1 then
      if x+1<maxX then inc(x)
      else dec(x)
     else if x-1>minX then dec(x)
          else inc(x);
     if Random(2)=1 then
      if y+1<maxY then inc(y)
      else dec(y)
     else if y-1>minY then dec(y)
          else inc(y);
     PutPixel(x,y,PixColor);
    end;
  until KeyPressed;
 end;

PROCEDURE Proba8;
 var i,d:integer;
 begin
  Borders;
  PutPixel(GetMaxX div 2,GetMaxY div 2,pixColor);
  for i:=1 to pixNumber do
   with pixels[i] do begin
    x:=GetMaxX div 2; y:=GetMaxY div 2;
   end;
  repeat
   for i:=1 to pixNumber do
    with pixels[i] do begin
     PutPixel(x,y,0);
     d:=Direct;
     if (x+d>minX) and (x+d<maxX) then
      inc(x,d)
     else dec(x,d);
     d:=Direct;
     if (y+d>minY) and (y+d<maxY) then
      inc(y,d)
     else dec(y,d);
     PutPixel(x,y,PixColor);
    end;
  until KeyPressed;
 end;

PROCEDURE Proba05;
 var i:integer;
 begin
  Borders;
  PutPixel(GetMaxX div 2,GetMaxY div 2,pixColor);
  for i:=1 to pixNumber do
   with pixels[i] do begin
    x:=GetMaxX div 2; y:=GetMaxY div 2;
   end;
  repeat
   for i:=1 to pixNumber do
    with pixels[i] do begin
     PutPixel(x,y,0);
     if Random>=0.5 then
      if x+1<maxX then inc(x)
      else dec(x)
     else if x-1>minX then dec(x)
          else inc(x);
     if Random>=0.5 then
      if y+1<maxY then inc(y)
      else dec(y)
     else if y-1>minY then dec(y)
          else inc(y);
     PutPixel(x,y,PixColor);
    end;
  until KeyPressed;
 end;

PROCEDURE InputVariables;
 begin
  beginX:=Random(maxX-2)+1;
  beginY:=Random(maxY-2)+1;
  shitX:=Random(maxX-2)+1;
  shitY:=Random(maxY-2)+1;
  enemyX:=Random(maxX-2)+1;
  enemyY:=Random(maxY-2)+1;
  pixNumber:=Random(499)+1;
  sens:=Random(999)+1;
  hungry:=(Random(9)+1)/10;
  fear:=(Random(9)+1)/10;
 end;

PROCEDURE ShitExperiment;
 var i,j:integer;
     num,numShit,numEnemy:byte;
     dis:real;
     s,ss:string;
 begin
  GrInit;
  Borders;
  SetColor(lightGray);
  OutTextXY(8,470,'    (c) MefodySoftware & Absira設 1998');
  SetColor(lightGray);
  STR(beginX,s);
  STR(beginY,ss);
  OutTextXY(MaxX+5,8,': '+s+','+ss);
  SetColor(shitColor);
  STR(shitX,s);
  STR(shitY,ss);
  OutTextXY(MaxX+5,24,': '+s+','+ss);
  SetColor(enemyColor);
  STR(enemyX,s);
  STR(enemyY,ss);
  OutTextXY(MaxX+5,40,'宥: '+s+','+ss);
  SetColor(lightGray);
  STR(pixNumber,s);
  OutTextXY(MaxX+5,56,'- : '+s);
  STR(sens,s);
  OutTextXY(MaxX+5,72,' :'+s);
  STR(hungry:3:1,s);
  OutTextXY(MaxX+5,88,' : '+s);
  STR(fear:3:1,s);
  OutTextXY(MaxX+5,104,' : '+s);

  PutPixel(beginX,beginY,pixColor);
  SetColor(shitColor);
  Circle(shitX,shitY,shitRad);
{  Circle(shitX,shitY,sens);}
  SetColor(enemyColor);
  Circle(enemyX,enemyY,enemyRad);
  SetWriteMode(XORPut);
  InitDirections;
  for i:=1 to pixNumber do
   with pixels[i] do begin
    x:=beginX; y:=beginY;
    color:=pixColor;
   end;
{  pixels[1].color:=lightRed;
  pixels[25].color:=lightGreen;
  pixels[100].color:=lightBlue; }
  repeat
   for i:=1 to pixNumber do
    with pixels[i] do begin
     PutPixel(x,y,0);
      numShit:=XYtoNum(Sign(shitX-x),Sign(shitY-y));
      dis:=DistanceShit(x,y);
      if dis<>0 then directions[numShit].ver:=0.875*hungry/SQRT(dis)
                else directions[numShit].ver:=0;
      { ࠢ   ( ) }
      numEnemy:=XYtoNum(Sign(x-enemyX),Sign(y-enemyY));
      dis:=DistanceEnemy(x,y);
      if dis<>0 then directions[numEnemy].ver:=0.875*fear/SQRT(DistanceEnemy(x,y))
                else directions[numEnemy].ver:=0;
      { ᫮ ஢   ⭮⥩ }
      num:=XYtoNum(Sign(directions[numShit].x*directions[numShit].ver+
                        directions[numEnemy].x*directions[numEnemy].ver),
                   Sign(directions[numShit].y*directions[numShit].ver+
                        directions[numEnemy].y*directions[numEnemy].ver));
      directions[num].ver:=0.125+SQRT(SQR(directions[numShit].x*directions[numShit].ver+
                                    directions[numEnemy].x*directions[numEnemy].ver)+
                               SQR(directions[numShit].y*directions[numShit].ver+
                                   directions[numEnemy].y*directions[numEnemy].ver));
      { ⭮ ⠢ ࠢ }
      for j:=1 to 8 do
       if j<>num then directions[j].ver:=(1-directions[num].ver)/7;
     num:=PixDirect;
     if (x+directions[num].x>minX) and (x+directions[num].x<maxX) then
      inc(x,directions[num].x)
     else dec(x,directions[num].x);
     if (y+directions[num].y>minY) and (y+directions[num].y<maxY) then
      inc(y,directions[num].y)
     else dec(y,directions[num].y);
     PutPixel(x,y,color);
    end;
   SetColor(shitColor);
   Circle(shitX,shitY,shitRad);
  until KeyPressed;
  CloseGraph;
 end;

PROCEDURE Zastava;
 var
  leftPos:integer;
  i,j,n:byte;
  message:string;
  pal:PaletteType;
 begin
  GrInit;
  message:='Mefody Software';
  leftPos:=(GetMaxX-Length(message)*16) div 2;
  for i:=1 to Length(message) do begin
   SetTextStyle(Font,HorizDir,2);
   SetColor(LightCyan);
   OutTextXY(leftPos+(i-1)*16,GetMaxY div 2 -8,message[i]);
   Delay(300);
   SetColor(Black);
   OutTextXY(leftPos+(i-1)*16,GetMaxY div 2 -8,message[i]);
   SetTextStyle(Font,HorizDir,1);
   SetColor(Cyan);
   OutTextXY(leftPos+(i-1)*16+4,GetMaxY div 2 -4,message[i]);
   Delay(200);
  end;
  ClearDevice;
  message:='presents';
  leftPos:=(GetMaxX-Length(message)*8) div 2;
  GetPalette(pal);
  for i:=0 to 31 do begin
   SetRGBPalette(3,i,i*2,i*2);
   OutTextXY(leftPos,GetMaxY div 2 -4,message);
   Delay(400);
  end;
  Delay(3000);
  ClearDevice;
  CloseGraph;
{  message:='FLIES';
  SetTextStyle(Font,HorizDir,4);
  leftPos:=(GetMaxX-Length(message)*24) div 2;
  GetPalette(pal);
  for i:=0 to 31 do begin
   SetRGBPalette(3,i,i*2,i*2);
   OutTextXY(leftPos,GetMaxY div 2 -4,message);
   Delay(800);
  end;
  Delay(3000);
  ClearDevice;}
 end;

BEGIN
{ Zastava;}
 Randomize;
 InputVariables;
 ShitExperiment;
 CloseGraph;
END.